package net.minecraft.src;

public class EntitySpellParticleColorFX extends EntitySpellParticleFX
{
    private int field_40111_a;

    public EntitySpellParticleColorFX(World world, double d, double d1, double d2,
            double d3, double d4, double d5, int r, int g, int b)
    {
        super(world, d, d1, d2, d3, d4, d5);
        float r1 = r;
        float g1 = g;
        float b1 = b;
        red = (1.0F / 255F) * r1;
        green = (1.0F / 255F) * g1;
        blue = (1.0F / 255F) * b1;
    }

    public void func_40097_b(float f, float f1, float f2)
    {
        particleRed = red;
        particleGreen = green;
        particleBlue = blue;
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5)
    {
    	particleRed = red;
        particleGreen = green;
        particleBlue = blue;
        float f6 = (((float)particleAge + f) / (float)particleMaxAge) * 32F;
        if (f6 < 0.0F)
        {
            f6 = 0.0F;
        }
        if (f6 > 1.0F)
        {
            f6 = 1.0F;
        }
        float f14 = (float)(getParticleTextureIndex() % 16) / 16F;
        float f7 = f14 + 0.0624375F;
        float f8 = (float)(getParticleTextureIndex() / 16) / 16F;
        float f9 = f8 + 0.0624375F;
        float f10 = 0.1F * particleScale;
        float f11 = (float)((prevPosX + (posX - prevPosX) * (double)f) - interpPosX);
        float f12 = (float)((prevPosY + (posY - prevPosY) * (double)f) - interpPosY);
        float f13 = (float)((prevPosZ + (posZ - prevPosZ) * (double)f) - interpPosZ);
        tessellator.setColorOpaque_F(particleRed, particleGreen, particleBlue);
        tessellator.addVertexWithUV(f11 - f1 * f10 - f4 * f10, f12 - f2 * f10, f13 - f3 * f10 - f5 * f10, f7, f9);
        tessellator.addVertexWithUV((f11 - f1 * f10) + f4 * f10, f12 + f2 * f10, (f13 - f3 * f10) + f5 * f10, f7, f8);
        tessellator.addVertexWithUV(f11 + f1 * f10 + f4 * f10, f12 + f2 * f10, f13 + f3 * f10 + f5 * f10, f14, f8);
        tessellator.addVertexWithUV((f11 + f1 * f10) - f4 * f10, f12 - f2 * f10, (f13 + f3 * f10) - f5 * f10, f14, f9);
    }

    public float red;
    public float green;
    public float blue;
}